﻿<# 
 Programma om cetool.ps1 te installeren.
 Versie 0.1.1
 Auteur: Benvindo Neves
#>

# toevoegen .NET framework klassen ---------------------------------------------------------
# [Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms") | Out-Null
Add-Type -AssemblyName System.Windows.Forms
Add-Type -AssemblyName PresentationFramework
Add-Type -AssemblyName System.Drawing

# VisualStyles aan zetten ------------------------------------------------------------------
[System.Windows.Forms.Application]::EnableVisualStyles()

<# Variabelen. 
   PathSelect is de map die je kiest om te installeren.
   Het is global gemaakt om overal te kunnen werken
   Het wijst in het begin naar de profielmap van de gebruiker
#>
$global:PathSelect="$env:USERPROFILE\cetool"

# path_start is de startmap als je een map gaat kiezen. deze waarde blijft altijf dezelfde, i.t.t. PathSelect.
$Path_start = "$Global:PathSelect"

# hoofd programma die uitgevoerd wordt
[string] $hoofdprog = "cetool.ps1"

# Locatie van de executeable van Powershell in een windows 64bit systeem. 
# Let op dat bij een 32bit systeem dit anders is.
[string] $locatiePSexe = "c:\windows\system32\WindowsPowerShell\v1.0\powershell.exe"

# update is de naam van het zip bestand dat wordt uitgepakt. Dit bestand bevat het programma.
$update = "bestanden.zip"

# hoofdvenster wordt gedeclareerd

$Form                            = New-Object system.Windows.Forms.Form
$Form.ClientSize                 = New-Object System.Drawing.Point(850,500)
$Form.text                       = "Installeren van CE-tool"
$Form.TopMost                    = $false

$Description                     = New-Object system.Windows.Forms.Label
$Description.text                = "Welkom. 

Dit is het installatieprogramma van CE-tool, een programma om een Excelbestand uit Eduarte om te zetten naar
een gecomprimeerd bestand met xml-bestanden voor Facet. 
U kunt de installatiemap of enkele opties nog wijzigen. 
Klik op Installeren om met de installatie te beginnen."
$Description.AutoSize            = $false
$Description.width               = 800
$Description.height              = 120
$Description.location            = New-Object System.Drawing.Point(20,15)
$Description.Font                = 'Microsoft Sans Serif,11'

$uitleg1                     = New-Object system.Windows.Forms.Label
$uitleg1.text                = "Het programma wordt geïnstalleerd in :"
$uitleg1.AutoSize            = $false
$uitleg1.width               = 550
$uitleg1.height              = 30
$uitleg1.location            = New-Object System.Drawing.Point(40,140)
$uitleg1.Font                = 'Microsoft Sans Serif,11'

$uitleg2                     = New-Object system.Windows.Forms.Label
$uitleg2.text                = "$Global:PathSelect"
$uitleg2.AutoSize            = $false
$uitleg2.width               = 700
$uitleg2.height              = 60
$uitleg2.location            = New-Object System.Drawing.Point(40,170)
$uitleg2.Font                = 'Microsoft Sans Serif,11'

$BtnOpenFileDialog = New-object System.Windows.Forms.Button 
$BtnOpenFileDialog.text= "Wijzig de installatie map"   
$BtnOpenFileDialog.location = "50,220" 
$BtnOpenFileDialog.size = "250,40"  
$BtnOpenFileDialog.Add_Click({ Find-Folders }) 

$snelkoppeling = New-Object System.Windows.Forms.Checkbox 
$snelkoppeling.Location = New-Object System.Drawing.Point(50,280)
$snelkoppeling.Size = New-Object System.Drawing.Size(700,30)
$snelkoppeling.Text = "Maak een snelkoppeling naar het programma op het bureaublad."
$snelkoppeling.Font = 'Microsoft Sans Serif,11'
$snelkoppeling.checked = $true

$schoneinstall = New-Object System.Windows.Forms.Checkbox 
$schoneinstall.Location = New-Object System.Drawing.Point(50,320)
$schoneinstall.Size = New-Object System.Drawing.Size(700,30)
$schoneinstall.Text = "Voer een schone installatie van het programma uit."
$schoneinstall.Font = 'Microsoft Sans Serif,11'
$schoneinstall.checked = $false

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Installeren"
$Btnstart.location = "50,400" 
$Btnstart.size = "250,40"  
$Btnstart.DialogResult = [System.Windows.Forms.DialogResult]::OK
$form.AcceptButton = $Btnstart

$Btncancel = New-object System.Windows.Forms.Button 
$Btncancel.text= "Annuleren"
$Btncancel.location = "350,400" 
$Btncancel.size = "250,40"  
$Btncancel.DialogResult = [System.Windows.Forms.DialogResult]::Cancel
$form.CancelButton = $Btncancel

$Form.controls.AddRange(@($Description,$BtnOpenFileDialog, $snelkoppeling, $schoneinstall, $Btnstart, $uitleg1, $uitleg2, $Btncancel ))
$form.Topmost = $false

# functions --------------------------------------------------------------

function Find-Folders {
    
    $browse = New-Object System.Windows.Forms.FolderBrowserDialog
    $browse.SelectedPath = "$Path_start"
    $browse.ShowNewFolderButton = $true
    $browse.Description = "Selecteer de map waar de programma wordt geïnstalleerd."
    
    if ($browse.ShowDialog() -eq "OK")
        {

        # controleren of je schrijfrechten heb op deze map
        $permission = (Get-Acl $browse.SelectedPath).Access | Where-Object{$_.IdentityReference -match $env:Username} | Select-Object IdentityReference,FileSystemRights

        if ($permission) {         
            
            $uitleg2.text = $browse.SelectedPath
            $global:PathSelect = $browse.SelectedPath
        } else {
            [System.Windows.Forms.MessageBox]::Show( "Huidige gebruiker heeft geen rechten op deze map", "U kunt deze map niet kiezen!", "OK", "Warning" )
        }
		
		}
		
    $browse.Dispose()
}


# hoofdvenster wordt opgestart ------------------------------------------------
$startinstallatie = $form.ShowDialog()

# installatie starten als op installeren is geklikt
if ($startinstallatie -eq [system.windows.forms.dialogResult]::OK)
    {
      # opstart venster declareren en weergeven ----------------------------------------------------------------------
    $Form_opstart                     = New-Object system.Windows.Forms.Form
    $Form_opstart.ClientSize          = New-Object System.Drawing.Point(450,180)
    $Form_opstart.text                = "Installeren van CE-tool"
    $Form_opstart.TopMost             = $false
    $Form_opstart.StartPosition       = 'CenterScreen'
    $Form_opstart.BackColor           = "white"
    $Form_opstart.ControlBox = $False

    $opstarttekst                     = New-Object system.Windows.Forms.Label
    $opstarttekst.text                = "Programma wordt geïnstalleerd..."
    $opstarttekst.AutoSize            = $false
    $opstarttekst.width               = 400
    $opstarttekst.height              = 30
    $opstarttekst.location            = New-Object System.Drawing.Point(20,15)
    $opstarttekst.Font                = 'Microsoft Sans Serif,12'
    $opstarttekst.ForeColor = [System.Drawing.Color]::Blue
    $Form_opstart.Controls.Add($opstarttekst)
    
    $Form_opstart.Show()
    # nodig om proces de tijd te geven om de tekst te laten zien.
    Start-Sleep -Milliseconds 500  
      
    # naar de map gaan waar het programma is opgestart. Kan nodig zijn afhankelijk van hoe het programma is opgestart.
    Set-Location "$PSScriptRoot"

    # controleren of het zip bestand bestaat
    if ( -not (Test-Path -Path $update) ) {
        [System.Windows.Forms.MessageBox]::Show( "Het zip bestand is niet gevonden. Controleer of het bestand aanwezig is.", "Foutmelding", "OK", "Error" )
        $Form_opstart.dispose()
        exit
    }
    # schone installatie uitvoeren. dus eerst de gekozen map leeg maken.
    if ( ($schoneinstall.checked -eq $true) -and ((test-path -path $Global:PathSelect\*) -eq $true) ) {
            Remove-Item "$Global:PathSelect\*" -Recurse -Force
            }

    # uitpakken en installeren van programma
    Expand-Archive -Path "$update" -DestinationPath "$Global:PathSelect" -Force

    # sluiten installatie scherm
    $Form_opstart.dispose()
 
    # snelkoppeling maken als vinkje is gezet
    if ($snelkoppeling.checked -eq $true) { 
            # samenvoegen installatiemap met hoofdprogramma.
            $hoofdprog = -join ("$Global:PathSelect","\","$hoofdprog")
            # variabele voor het maken van de snelkoppeling
            $SourceFilePath = $locatiePSexe
            $linkbureaublad = [Environment]::GetFolderPath("Desktop")
            $ShortcutPath = "$linkbureaublad\CE-tool.lnk"
            $WScriptObj = New-Object -ComObject ("WScript.Shell")
            $shortcut = $WscriptObj.CreateShortcut($ShortcutPath)
            $shortcut.TargetPath = $SourceFilePath
            $shortcut.Arguments = "-ExecutionPolicy Bypass -WindowStyle Hidden -NoProfile -file " + '"' + "$hoofdprog" + '"' 
            # $shortcut.Arguments = "-ExecutionPolicy Bypass -NoProfile -file " + '"' + "$hoofdprog" + '"' 
            $shortcut.IconLocation = "$Global:PathSelect" + "\" + "cetool_icoon.ico"
            $shortcut.WorkingDirectory = "$Global:PathSelect"
            # Maak de snelkoppeling aan op het bureaublad
            $shortcut.Save()
            }
        
    # Display a message box indicating that installation is completed
    [System.Windows.Forms.MessageBox]::Show( "Installeren is gelukt", "Script completed", "OK", "Information" )

    # terug naar de map gaan waar het programma is opgestart.
    Set-Location "$PSScriptRoot"
    
    }
    # Einde script  